<?php
/**
 * Sales Orders Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Sales_orders extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Sales_orders_model');
		$this->load->model('Customers_model');
		$this->load->model('Items_model');
		$this->load->model('Logs_model');
		$this->load->model('Wholesale_prices_model');
		$this->load->model('Special_prices_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
 	{	
		$data['content_title'] = 'Penjualan';
		
		if(check_roles('1')){
			$this->twiggy_display('adm/sales_orders/index', $data);
		}else{
			redirect("Error");
		}
	}
	 
	public function get_data_header()
	{	
		$data = [];
		$order = "sales_order_header_number DESC";
		$get_data = $this->Sales_orders_model->salesorder_header('', $order)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{	
				$data[] = array(
					'no'          => $no,
					'id'          => $get_row->sales_order_header_id,
					'number'      => $get_row->sales_order_header_number,
					'date'        => indonesian_date($get_row->sales_order_header_date),
					'customer'    => $get_row->customer_name,
					'grand_total' => number_format($get_row->sales_order_header_grand_total),
					'description' => $get_row->sales_order_header_description,
				);
				$no++;
			}
		}

		$response = [
            'data'         => $data,
            'recordsTotal' => count($data)
        ];

        output_json($response);
	}

	public function get_payment_term()
	{
		$customer         = $this->input->post('customer');
		$sales_order_date = change_format_date($this->input->post('sales_order_date'));

		$where        = array('customer_id' => $customer);
		$payment_term = $this->Customers_model->get_data($where)->row()->customer_payment_term;
		$payment_due  = date("Y-m-d", strtotime('+' ."$payment_term". ' days', strtotime($sales_order_date)));
		
		$response = [
            'payment_term' => $payment_term ." Hari",
            'payment_due'  => change_format_date($payment_due, 'd/m/Y')
		];
		
		echo json_encode($response);
	}

	public function get_wholesale_price()
	{
		$customer       = $this->input->post('customer');
		$item           = $this->input->post('item');
		$quantity_large = $this->input->post('quantity_large');

		$where_special_price    = array('a.customer_id' => $customer, 'a.item_id' => $item);
		$get_data_special_price = $this->Special_prices_model->get_data($where_special_price)->result();

		$price = 0;
		if(!empty($get_data_special_price)){
			return false;
		}else{
			$get_wholesale_price = $this->Wholesale_prices_model->get_data_range($item, $quantity_large)->row_array();
			if(!empty($get_wholesale_price)){
				$price = $get_wholesale_price['price'];
			}else{
				$where_last_price    = array('item_id' => $item);
				$get_data_last_price = $this->Items_model->get_data($where_last_price)->row_array();
				$price               = $get_data_last_price['last_selling_price_large_unit'];
			}
			echo json_encode(number_format($price));
		}
	}

 	public function edit($id = 'new')
	{
		$title = "Tambah Penjualan";
		$header_data = array(null);

		$prefix  = "TX";
		$datenow = date('Ym');
		$number_generator = $this->Sales_orders_model->salesorder_autonumber();
		$autonumber = $prefix.$datenow.$number_generator;

		$date_text   = change_format_date(date_now(), 'd/m/Y');

	    if($id != 'new')
	    {
			$title       = "Edit Penjualan";
			$where       = array('sales_order_header_id' => $id);
			$header_data = $this->Sales_orders_model->salesorder_header($where)->row_array();
			$autonumber  = $header_data['sales_order_header_number'];
			$date_text   = change_format_date($header_data['sales_order_header_date'], 'd/m/Y');
		}

		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['header_data']   = $header_data;
		$data['customer_data']   = $this->Customers_model->get_data()->result();

		
		$data['autonumber'] = $autonumber;
		$data['date_text']  = $date_text;

		if(check_roles('1')){
			$this->twiggy_display('adm/sales_orders/edit', $data);
		}else{
			redirect("Error");
		}
	}

	public function get_data_detail()
	{	
		$id = $this->input->post("id");
		$where       = array('sales_order_detail_header_id' => $id);
		$order       = array('item_name' => 'asc');

		$data = [];
		$get_data = $this->Sales_orders_model->salesorder_detail($where)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{

				$data[] = array(
					'no'               => $no,
					'detail_id'        => $get_row->sales_order_detail_id,
					'detail_header_id' => $get_row->sales_order_detail_header_id,
					'id'               => $get_row->sales_order_detail_item_id,
					'name'             => $get_row->sales_order_detail_item_name,
					'lg_unit'          => $get_row->sales_order_detail_large_unit,
					'lg_unit_cnt'      => floor($get_row->large_unit_contain),
					'lg_unit_qty'      => floor($get_row->sales_order_detail_large_unit_quantity),
					'lg_unit_prc'      => number_format($get_row->sales_order_detail_large_unit_price),
					'result_large'     => $get_row->sales_order_detail_result_large,
					'md_unit'          => $get_row->sales_order_detail_medium_unit,
					'md_unit_cnt'      => floor($get_row->medium_unit_contain),
					'md_unit_qty'      => floor($get_row->sales_order_detail_medium_unit_quantity),
					'md_unit_prc'      => number_format($get_row->sales_order_detail_medium_unit_price),
					'result_medium'    => $get_row->sales_order_detail_result_medium,
					'sm_unit'          => $get_row->sales_order_detail_small_unit,
					'sm_unit_cnt'      => floor($get_row->small_unit_contain),
					'sm_unit_qty'      => floor($get_row->sales_order_detail_small_unit_quantity),
					'sm_unit_prc'      => number_format($get_row->sales_order_detail_small_unit_price),
					'result_small'     => $get_row->sales_order_detail_result_small,
					'total'            => number_format($get_row->sales_order_detail_total),
				);
				$no++;
			}
		}

		output_json($data);
	}

	public function get_embed()
	{
		$data = [];
		$data['content_title'] = 'Data Barang';
		$this->twiggy_display('adm/sales_orders/embed', $data);
	}

	public function get_data_embed()
	{
		$data     = [];
		$response = [];
		$search   = $this->input->post('search');
		$customer = $this->input->post('customer');

		$get_data = $this->Items_model->get_data_search($search)->result();

		$no = 0;
		foreach($get_data as $get_row)
		{	
			$large_unit_price  = $get_row->last_selling_price_large_unit;
			$medium_unit_price = $get_row->last_selling_price_medium_unit;
			$small_unit_price  = $get_row->last_selling_price_small_unit;

			$where_special_price    = array('a.customer_id' => $customer, 'a.item_id' => $get_row->item_id);
			$get_data_special_price = $this->Special_prices_model->get_data($where_special_price)->row();

			if($get_data_special_price){
				$large_unit_price = $get_data_special_price->price;
			}

			$data[] = array(
					'no'               => $no,
					'id'               => $get_row->item_id,
					'name'             => $get_row->item_name,
					'group_id'         => $get_row->group_id,
					'group_name'       => $get_row->group_name,
					'group_child_id'   => $get_row->group_child_id,
					'group_child_name' => $get_row->group_child_name,
					'lg_unit'          => $get_row->large_unit,
					'lg_unit_cnt'      => floor($get_row->large_unit_contain),
					'lg_unit_prc'      => number_format($large_unit_price),
					'md_unit'          => $get_row->medium_unit,
					'md_unit_cnt'      => floor($get_row->medium_unit_contain),
					'md_unit_prc'      => number_format($medium_unit_price),
					'sm_unit'          => $get_row->small_unit,
					'sm_unit_cnt'      => floor($get_row->small_unit_contain),
					'sm_unit_prc'      => number_format($small_unit_price),
					'btncolor'         => '',
					'btnicon'          => '',
			);

			$no++;
		}

		$response = [
            'data'         => $data,
            'recordsTotal' => count($data)
        ];

		output_json($response);
		
	}

	public function save()
	{	
		$id             = $this->input->post('id');
		$number         = $this->input->post("number");
		$date           = $this->input->post("date");
		$customer       = $this->input->post("customer");
		$payment_method = $this->input->post("payment_method");
		$payment_term   = $this->input->post("payment_term");
		$payment_due    = $this->input->post("payment_due");
		$grand_total    = $this->input->post("grand_total");
		$description    = $this->input->post("description");
		
		$vuedata = $this->input->post('vuedata');

		$payment_term_data = ($payment_term == "" ? "0" : substr($payment_term ,0 ,-5));
		$payment_due_data  = ($payment_due == "" ? "0000-00-00" : change_format_date($payment_due));

		$header_id   = $id;
		$header_data = [
			'sales_order_header_number'                => $number,
			'sales_order_header_date'                  => change_format_date($date),
			'sales_order_header_customer_id'           => $customer,
			'sales_order_header_payment_method'        => $payment_method,
			'sales_order_header_payment_term'          => $payment_term_data,
			'sales_order_header_payment_due'           => $payment_due_data,
			'sales_order_header_grand_total'           => trims($grand_total),
			'sales_order_header_description'           => $description,
		];

		$detail_data = [];
		$log_data = [];

		// if save $id = new else update data
		if($id == "new")
		{
			// save header
			$save_header = $this->Sales_orders_model->save_header($header_data);
			if($save_header)
			{
				$header_id = $this->db->insert_id();
				foreach($vuedata as $row)
				{
					$detail_data[] = [
						'sales_order_detail_header_id'            => $header_id,
						'sales_order_detail_item_id'              => $row['id'],
						'sales_order_detail_item_name'            => $row['name'],
						'sales_order_detail_large_unit'           => $row['lg_unit'],
						'sales_order_detail_large_unit_quantity'  => trims($row['lg_unit_qty']),
						'sales_order_detail_large_unit_price'     => trims($row['lg_unit_prc']),
						'sales_order_detail_result_large'         => trims($row['result_large']),
						'sales_order_detail_medium_unit'          => $row['md_unit'],
						'sales_order_detail_medium_unit_quantity' => trims($row['md_unit_qty']),
						'sales_order_detail_medium_unit_price'    => trims($row['md_unit_prc']),
						'sales_order_detail_result_medium'        => trims($row['result_medium']),
						'sales_order_detail_small_unit'           => $row['sm_unit'],
						'sales_order_detail_small_unit_quantity'  => trims($row['sm_unit_qty']),
						'sales_order_detail_small_unit_price'     => trims($row['sm_unit_prc']),
						'sales_order_detail_result_small'         => trims($row['result_small']),
						'sales_order_detail_total'                => trims($row['total'])
					];

					$where                 = array('log_item_id' => $row['id']);
					$log_data_check        = $this->Logs_model->get_data_last($where)->row_array();
					$last_total_stock      = 0;
					$last_log_total_stock_value = 0;
					$last_log_avg_large = 0;

					if(!empty($log_data_check)){
						$last_total_stock           = $log_data_check['log_total_stock'];
						$last_log_total_stock_value = $log_data_check['log_total_stock_value'];
						$last_log_avg_large         = $log_data_check['log_average_large_unit'];
					}

					$medium_purchase_price = ($row['md_unit_cnt'] == 0 ? 0 : ($last_log_avg_large / $row['md_unit_cnt']));
					$small_purchase_price = ($row['sm_unit_cnt'] == 0 ? 0 : ($last_log_avg_large / $row['lg_unit_cnt']));

					$log_total_transaction_in_small_unit = ($row['lg_unit_cnt'] * (- trims($row['lg_unit_qty']))) + ($row['md_unit_cnt'] * (- trims($row['md_unit_qty']))) + ($row['sm_unit_cnt'] * (- trims($row['sm_unit_qty'])));
					$log_total_transaction_value = ((- trims($row['lg_unit_qty'])) * $last_log_avg_large) + ((- trims($row['md_unit_qty'])) * $medium_purchase_price) + ((- trims($row['sm_unit_qty'])) * $small_purchase_price);
					$log_total_stock		     = ($last_total_stock + $log_total_transaction_in_small_unit);
					$log_total_stock_value       = ($last_log_total_stock_value + $log_total_transaction_value);
					// $log_average_small_unit      = ($log_total_stock_value / $log_total_stock);
					$log_average_small_unit      = ($log_total_stock == 0 ? 0 : ($log_total_stock_value / $log_total_stock));
					$log_average_medium_unit     = ($log_average_small_unit * $row['md_unit_cnt']);
					$log_average_large_unit      = ($log_average_small_unit * $row['lg_unit_cnt']);

					$log_data[] = [
						'log_type'                            => 'SELL',
						'log_transaction_id'                  => $header_id,
						'log_item_id'                         => $row['id'],
						'log_large_unit'                      => $row['lg_unit'],
						'log_large_unit_contain'              => $row['lg_unit_cnt'],
						'log_large_unit_quantity'             => (- trims($row['lg_unit_qty'])),
						'log_large_unit_purchase_price'       => $last_log_avg_large,
						'log_large_unit_selling_price'        => trims($row['lg_unit_prc']),
						'log_medium_unit'                     => $row['md_unit'],
						'log_medium_unit_contain'             => $row['md_unit_cnt'],
						'log_medium_unit_quantity'            => (- trims($row['md_unit_qty'])),
						'log_medium_unit_purchase_price'      => $medium_purchase_price,
						'log_medium_unit_selling_price'       => trims($row['md_unit_prc']),
						'log_small_unit'                      => $row['sm_unit'],
						'log_small_unit_contain'              => $row['sm_unit_cnt'],
						'log_small_unit_quantity'             => (- trims($row['sm_unit_qty'])),
						'log_small_unit_purchase_price'       => $small_purchase_price,
						'log_small_unit_selling_price'        => trims($row['sm_unit_prc']),
						'log_total_transaction_in_small_unit' => $log_total_transaction_in_small_unit,
						'log_total_transaction_value'         => $log_total_transaction_value,
						'log_total_stock'                     => $log_total_stock,
						'log_total_stock_value'               => $log_total_stock_value,
						'log_average_large_unit'              => $log_average_large_unit,
						'log_average_medium_unit'             => $log_average_medium_unit,
						'log_average_small_unit'              => $log_average_small_unit
					];

					$data_item = array(
						'last_selling_price_large_unit'  => trims($row['lg_unit_prc']),
						'last_selling_price_medium_unit' => trims($row['md_unit_prc']),
						'last_selling_price_small_unit'  => trims($row['sm_unit_prc']),
					);

					$where_item = $row['id'];

					$update_item = $this->Items_model->update($where_item, $data_item);
				}
				
				$save_detail = $this->Sales_orders_model->save_detail($detail_data, true);
				
				if($save_detail)
				{	
					$save_log = $this->Logs_model->save($log_data, true);

					if($save_log)
					{	
						$msg    = "Berhasil menyimpan data";
						$status = "success";
					}
					else
					{
						$msg    = "Gagal menyimpan data";
						$status = "error";	
					}
				}
				else
				{
					$msg    = "Gagal menyimpan data";
					$status = "error";	
				}
			}
			else
			{
				$msg    = "Gagal menyimpan data";
				$status = "error";	
			}
			
		}else{
			
			$delete_detail = $this->Sales_orders_model->delete_detail($id);

			if ($delete_detail) {
				$save_header = $this->Sales_orders_model->update_header($id, $header_data);

				if($save_header)
				{
					// $header_id = $this->db->insert_id();
					foreach($vuedata as $row)
					{
						$detail_data[] = [
							'sales_order_detail_header_id'            => $header_id,
							'sales_order_detail_item_id'              => $row['id'],
							'sales_order_detail_item_name'            => $row['name'],
							'sales_order_detail_large_unit'           => $row['lg_unit'],
							'sales_order_detail_large_unit_quantity'  => trims($row['lg_unit_qty']),
							'sales_order_detail_large_unit_price'     => trims($row['lg_unit_prc']),
							'sales_order_detail_result_large'         => trims($row['result_large']),
							'sales_order_detail_medium_unit'          => $row['md_unit'],
							'sales_order_detail_medium_unit_quantity' => trims($row['md_unit_qty']),
							'sales_order_detail_medium_unit_price'    => trims($row['md_unit_prc']),
							'sales_order_detail_result_medium'        => trims($row['result_medium']),
							'sales_order_detail_small_unit'           => $row['sm_unit'],
							'sales_order_detail_small_unit_quantity'  => trims($row['sm_unit_qty']),
							'sales_order_detail_small_unit_price'     => trims($row['sm_unit_prc']),
							'sales_order_detail_result_small'         => trims($row['result_small']),
							'sales_order_detail_total'                => trims($row['total']),
						];

						$data_item = array(
							'last_selling_price_large_unit'  => trims($row['lg_unit_prc']),
							'last_selling_price_medium_unit' => trims($row['md_unit_prc']),
							'last_selling_price_small_unit'  => trims($row['sm_unit_prc']),
						);

						$where_item = $row['id'];

						$update_item = $this->Items_model->update($where_item, $data_item);

						$where_check = array('log_transaction_id' => $header_id, 'log_item_id' => $row['id']);
						$logs_id_check = $this->Logs_model->get_data($where_check)->row();
						if(!empty($logs_id_check)){
							$where_a = array('log_transaction_id' => $header_id, 'log_item_id' => $row['id']);
							$logs_id_a = $this->Logs_model->get_data($where_a)->row()->log_id;
							$where_b = array('log_item_id' => $row['id'], 'log_id <' => $logs_id_a);
							$log_data_check = $this->Logs_model->get_data_last($where_b)->row_array();
							$last_total_stock      = 0;
							$last_log_total_stock_value = 0;
							$last_log_avg_large = 0;

							if(!empty($log_data_check)){
								$last_total_stock      		= $log_data_check['log_total_stock'];
								$last_log_total_stock_value = $log_data_check['log_total_stock_value'];
								$last_log_avg_large = $log_data_check['log_average_large_unit'];
							}


							// $medium_purchase_price = ($last_log_avg_large / $row['md_unit_cnt']);
							// $small_purchase_price = ($last_log_avg_large / $row['lg_unit_cnt']);
							$medium_purchase_price = ($row['md_unit_cnt'] == 0 ? 0 : ($last_log_avg_large / $row['md_unit_cnt']));
							$small_purchase_price = ($row['sm_unit_cnt'] == 0 ? 0 : ($last_log_avg_large / $row['lg_unit_cnt']));

							$log_total_transaction_in_small_unit = ($row['lg_unit_cnt'] * (- trims($row['lg_unit_qty']))) + ($row['md_unit_cnt'] * (- trims($row['md_unit_qty']))) + ($row['sm_unit_cnt'] * (- trims($row['sm_unit_qty'])));
							$log_total_transaction_value = ((- trims($row['lg_unit_qty'])) * $last_log_avg_large) + ((- trims($row['md_unit_qty'])) * $medium_purchase_price) + ((- trims($row['sm_unit_qty'])) * $small_purchase_price);
							$log_total_stock		     = ($last_total_stock + $log_total_transaction_in_small_unit);
							$log_total_stock_value       = ($last_log_total_stock_value + $log_total_transaction_value);
							// $log_average_small_unit      = ($log_total_stock_value / $log_total_stock);
							$log_average_small_unit      = ($log_total_stock == 0 ? 0 : ($log_total_stock_value / $log_total_stock));
							$log_average_medium_unit     = ($log_average_small_unit * $row['md_unit_cnt']);
							$log_average_large_unit      = ($log_average_small_unit * $row['lg_unit_cnt']);
							
							$this_row_data_update = array(
								'log_type'                            => 'SELL',
								'log_transaction_id'                  => $header_id,
								'log_item_id'                         => $row['id'],
								'log_large_unit'                      => $row['lg_unit'],
								'log_large_unit_contain'              => $row['lg_unit_cnt'],
								'log_large_unit_quantity'             => (- trims($row['lg_unit_qty'])),
								'log_large_unit_purchase_price'       => $last_log_avg_large,
								'log_large_unit_selling_price'        => trims($row['lg_unit_prc']),
								'log_medium_unit'                     => $row['md_unit'],
								'log_medium_unit_contain'             => $row['md_unit_cnt'],
								'log_medium_unit_quantity'            => (- trims($row['md_unit_qty'])),
								'log_medium_unit_purchase_price'      => $medium_purchase_price,
								'log_medium_unit_selling_price'       => trims($row['md_unit_prc']),
								'log_small_unit'                      => $row['sm_unit'],
								'log_small_unit_contain'              => $row['sm_unit_cnt'],
								'log_small_unit_quantity'             => (- trims($row['sm_unit_qty'])),
								'log_small_unit_purchase_price'       => $small_purchase_price,
								'log_small_unit_selling_price'        => trims($row['sm_unit_prc']),
								'log_total_transaction_in_small_unit' => $log_total_transaction_in_small_unit,
								'log_total_transaction_value'         => $log_total_transaction_value,
								'log_total_stock'                     => $log_total_stock,
								'log_total_stock_value'               => $log_total_stock_value,
								'log_average_large_unit'              => $log_average_large_unit,
								'log_average_medium_unit'             => $log_average_medium_unit,
								'log_average_small_unit'              => $log_average_small_unit
							);

							$this_row_where_update = array(
								'log_transaction_id' => $header_id,
								'log_item_id'        => $row['id'],
							);

							$this_row_log_update = $this->Logs_model->update_item($this_row_where_update, $this_row_data_update);
						}else{
							$where_z               = array('log_item_id' => $row['id']);
							$log_data_check        = $this->Logs_model->get_data_last($where_z)->row_array();
							$last_total_stock      = 0;
							$last_log_total_stock_value = 0;
							$last_log_avg_large = 0;

							if(!empty($log_data_check)){
								$last_total_stock      		= $log_data_check['log_total_stock'];
								$last_log_total_stock_value = $log_data_check['log_total_stock_value'];
								$last_log_avg_large = $log_data_check['log_average_large_unit'];
							}

							$medium_purchase_price = ($row['md_unit_cnt'] == 0 ? 0 : ($last_log_avg_large / $row['md_unit_cnt']));
							$small_purchase_price = ($row['sm_unit_cnt'] == 0 ? 0 : ($last_log_avg_large / $row['lg_unit_cnt']));

							$log_total_transaction_in_small_unit = ($row['lg_unit_cnt'] * (- trims($row['lg_unit_qty']))) + ($row['md_unit_cnt'] * (- trims($row['md_unit_qty']))) + ($row['sm_unit_cnt'] * (- trims($row['sm_unit_qty'])));
							$log_total_transaction_value = ((- trims($row['lg_unit_qty'])) * $last_log_avg_large) + ((- trims($row['md_unit_qty'])) * $medium_purchase_price) + ((- trims($row['sm_unit_qty'])) * $small_purchase_price);
							$log_total_stock		     = ($last_total_stock + $log_total_transaction_in_small_unit);
							$log_total_stock_value       = ($last_log_total_stock_value + $log_total_transaction_value);
							// $log_average_small_unit      = ($log_total_stock_value / $log_total_stock);
							$log_average_small_unit      = ($log_total_stock == 0 ? 0 : ($log_total_stock_value / $log_total_stock));
							$log_average_medium_unit     = ($log_average_small_unit * $row['md_unit_cnt']);
							$log_average_large_unit      = ($log_average_small_unit * $row['lg_unit_cnt']);
							
							$this_row_data_save = array(
								'log_type'                            => 'SELL',
								'log_transaction_id'                  => $header_id,
								'log_item_id'                         => $row['id'],
								'log_large_unit'                      => $row['lg_unit'],
								'log_large_unit_contain'              => $row['lg_unit_cnt'],
								'log_large_unit_quantity'             => (- trims($row['lg_unit_qty'])),
								'log_large_unit_purchase_price'       => $last_log_avg_large,
								'log_large_unit_selling_price'        => trims($row['lg_unit_prc']),
								'log_medium_unit'                     => $row['md_unit'],
								'log_medium_unit_contain'             => $row['md_unit_cnt'],
								'log_medium_unit_quantity'            => (- trims($row['md_unit_qty'])),
								'log_medium_unit_purchase_price'      => $medium_purchase_price,
								'log_medium_unit_selling_price'       => trims($row['md_unit_prc']),
								'log_small_unit'                      => $row['sm_unit'],
								'log_small_unit_contain'              => $row['sm_unit_cnt'],
								'log_small_unit_quantity'             => (- trims($row['sm_unit_qty'])),
								'log_small_unit_purchase_price'       => $small_purchase_price,
								'log_small_unit_selling_price'        => trims($row['sm_unit_prc']),
								'log_total_transaction_in_small_unit' => $log_total_transaction_in_small_unit,
								'log_total_transaction_value'         => $log_total_transaction_value,
								'log_total_stock'                     => $log_total_stock,
								'log_total_stock_value'               => $log_total_stock_value,
								'log_average_large_unit'              => $log_average_large_unit,
								'log_average_medium_unit'             => $log_average_medium_unit,
								'log_average_small_unit'              => $log_average_small_unit
							);

							$this_row_log_update = $this->Logs_model->save($this_row_data_save);
						}


						// Update Data After ::::
						if($this_row_log_update){
							$where_1 = array('log_transaction_id' => $header_id, 'log_item_id' => $row['id']);
							$logs_id = $this->Logs_model->get_data($where_1)->row()->log_id;

							$where_2 = array('log_item_id' => $row['id'], 'log_id >' => $logs_id);
							$get_data_all_logs_by_item = $this->Logs_model->get_data($where_2)->result();

							foreach ($get_data_all_logs_by_item as $row) {

								$where_3 = array('log_item_id' => $row->log_item_id, 'log_id <' => $row->log_id);
								$one_line_before_log_data  = $this->Logs_model->get_data_last($where_3)->row_array();
								$one_line_before_total     = 0;
								$one_line_before_log_total = 0;
								$one_line_before_log_avg_large = 0;

								if(!empty($one_line_before_log_data)){
									$one_line_before_total     = $one_line_before_log_data['log_total_stock'];
									$one_line_before_log_total = $one_line_before_log_data['log_total_stock_value'];
									$one_line_before_log_avg_large = $one_line_before_log_data['log_average_large_unit'];
								}
								$log_total_stock	     = ($one_line_before_total + $row->log_total_transaction_in_small_unit);
								$log_total_stock_value   = ($one_line_before_log_total + $row->log_total_transaction_value);
								// $log_average_small_unit  = ($log_total_stock_value / $log_total_stock);
								$log_average_small_unit      = ($log_total_stock == 0 ? 0 : ($log_total_stock_value / $log_total_stock));
								$log_average_medium_unit = ($log_average_small_unit * $row->medium_unit_contain);
								$log_average_large_unit  = ($log_average_small_unit * $row->large_unit_contain);
								$after_row_data_update = array(
									'log_id'                  => $row->log_id,
									'log_total_stock'         => $log_total_stock,
									'log_total_stock_value'   => $log_total_stock_value,
									'log_average_large_unit'  => $log_average_large_unit,
									'log_average_medium_unit' => $log_average_medium_unit,
									'log_average_small_unit'  => $log_average_small_unit
								);

								$after_row_where_update = array(
									'log_id' => $row->log_id,
								);

								$after_row_log_update = $this->Logs_model->update_item($after_row_where_update, $after_row_data_update);
							}
						}
					}

					$save_detail = $this->Sales_orders_model->save_detail($detail_data, true);
					
					if($save_detail){
						$where_check_item_id  = array('log_type' => 'SELL', 'log_transaction_id' => $header_id);
						$get_data_log_item_id = $this->Logs_model->get_data($where_check_item_id)->result();

						foreach ($get_data_log_item_id as $row_list) {

							$where_item_id = array('sales_order_detail_header_id' => $header_id, 'item_id' => $row_list->log_item_id);
							$get_data_po_detail_now = $this->Sales_orders_model->salesorder_detail($where_item_id)->result();

							if(!empty($get_data_po_detail_now)){
								$after_row_log_update = true;
							}else{
								
								// Get Data Before This Item ID :::
								$where_before = array('log_item_id' => $row_list->log_item_id, 'log_id <' => $row_list->log_id);
								$get_before_data = $this->Logs_model->get_data_last($where_before)->row_array();
								$get_before_total_stock       = 0;
								$get_before_total_stock_value = 0;
								$get_before_avg_large = 0;

								if(!empty($get_before_data)){
									$get_before_total_stock = $get_before_data['log_total_stock'];
									$get_before_total_stock_value = $get_before_data['log_total_stock_value'];
									$get_before_avg_large = $get_before_data['log_average_large_unit'];
								}

								// Get Data After This Item ID :::
								$where_after = array('log_item_id' => $row_list->log_item_id, 'log_id >' => $row_list->log_id);
								$get_after_data = $this->Logs_model->get_data($where_after)->result();
								
								if($get_after_data){
									foreach ($get_after_data as $row_list_detail) {
										$where_log_delete = array(
											'log_item_id' => $row_list->log_item_id, 
											'log_id' => $row_list->log_id
										);

										$delete_logs = $this->Logs_model->delete($where_log_delete);
								
										$where_this = array('log_transaction_id' => $row_list_detail->log_transaction_id, 'log_item_id' => $row_list_detail->log_item_id);
										$log_id = $this->Logs_model->get_data($where_this)->row()->log_id;
										
										$where_3 = array('log_item_id' => $row_list_detail->log_item_id, 'log_id <' => $log_id);
										$one_line_before_log_data  = $this->Logs_model->get_data_last($where_3)->row_array();
										$one_line_before_total     = 0;
										$one_line_before_log_total = 0;
										$one_line_before_log_avg_large = 0;

										if(!empty($one_line_before_log_data)){
											$one_line_before_total     = $one_line_before_log_data['log_total_stock'];
											$one_line_before_log_total = $one_line_before_log_data['log_total_stock_value'];
											$one_line_before_log_avg_large = $one_line_before_log_data['log_average_large_unit'];
										}
										
										$log_total_stock	     = ($one_line_before_total + $row_list_detail->log_total_transaction_in_small_unit);
										$log_total_stock_value   = ($one_line_before_log_total + $row_list_detail->log_total_transaction_value);
										// $log_average_small_unit  = ($log_total_stock_value / $log_total_stock);
										$log_average_small_unit      = ($log_total_stock == 0 ? 0 : ($log_total_stock_value / $log_total_stock));
										$log_average_medium_unit = ($log_average_small_unit * $row_list_detail->medium_unit_contain);
										$log_average_large_unit  = ($log_average_small_unit * $row_list_detail->large_unit_contain);
										$after_row_data_update = array(
											'log_id'                  => $row_list_detail->log_id,
											'log_total_stock'         => $log_total_stock,
											'log_total_stock_value'   => $log_total_stock_value,
											'log_average_large_unit'  => $log_average_large_unit,
											'log_average_medium_unit' => $log_average_medium_unit,
											'log_average_small_unit'  => $log_average_small_unit
										);

										// echo json_encode($after_row_data_update);
										$after_row_where_update = array(
											'log_id' => $row_list_detail->log_id,
										);

										$after_row_log_update = $this->Logs_model->update_item($after_row_where_update, $after_row_data_update);
									}
								}else{
									$where_log_delete = array(
											'log_item_id' => $row_list->log_item_id, 
											'log_id' => $row_list->log_id
										);

									$delete_logs = $this->Logs_model->delete($where_log_delete);

									$after_row_log_update = true;
								}
							}
						}
					}
					else
					{
						$msg    = "Gagal menyimpan data";
						$status = "error";	
					}

					if($after_row_log_update)
					{
						$msg    = "Berhasil menyimpan data";
						$status = "success";
					}
					else
					{
						$msg    = "Gagal menyimpan data";
						$status = "error";	
					}
				}else{
					$msg    = "Gagal menyimpan data";
					$status = "error";
				}

			}else{
				$msg    = "Gagal menyimpan data";
				$status = "error";
			}
		}

		$response = [
			'message' => $msg,
			'status'  => $status,
			'id'      => $header_id
		];
		output_json($response);

	}

	public function delete()
	{
		$id = $this->input->post('id');
		$data_log = [];
		foreach($id as $row)
		{	
			$where = array('log_type' => 'SELL', 'log_transaction_id' => $row);
			$get_data_log = $this->Logs_model->get_data($where)->result();

			foreach ($get_data_log as $row_list) {

				// Get Data After This Item ID :::
				$where_after = array('log_item_id' => $row_list->log_item_id, 'log_id >' => $row_list->log_id);
				$get_after_data = $this->Logs_model->get_data($where_after)->result();

				if($get_after_data){
					foreach ($get_after_data as $row_list_detail) {
					
						$where_log_delete = array(
							'log_item_id' => $row_list->log_item_id, 
							'log_id' => $row_list->log_id
						);

						$delete_logs = $this->Logs_model->delete($where_log_delete);
				
						$where_this = array('log_transaction_id' => $row_list_detail->log_transaction_id, 'log_item_id' => $row_list_detail->log_item_id);
						$log_id = $this->Logs_model->get_data($where_this)->row()->log_id;
						
						$where_3 = array('log_item_id' => $row_list_detail->log_item_id, 'log_id <' => $log_id);
						$one_line_before_log_data  = $this->Logs_model->get_data_last($where_3)->row_array();
						$one_line_before_total     = 0;
						$one_line_before_log_total = 0;
						$one_line_before_log_avg_large = 0;

						if(!empty($one_line_before_log_data)){
							$one_line_before_total     = $one_line_before_log_data['log_total_stock'];
							$one_line_before_log_total = $one_line_before_log_data['log_total_stock_value'];
							$one_line_before_log_avg_large = $one_line_before_log_data['log_average_large_unit'];
						}

						$log_total_stock	     = ($one_line_before_total + $row_list_detail->log_total_transaction_in_small_unit);
						$log_total_stock_value   = ($one_line_before_log_total + $row_list_detail->log_total_transaction_value);
						// $log_average_small_unit  = ($log_total_stock_value / $log_total_stock);
						$log_average_small_unit      = ($log_total_stock == 0 ? 0 : ($log_total_stock_value / $log_total_stock));
						$log_average_medium_unit = ($log_average_small_unit * $row_list_detail->medium_unit_contain);
						$log_average_large_unit  = ($log_average_small_unit * $row_list_detail->large_unit_contain);

						$after_row_data_update = array(
							'log_id'                  => $row_list_detail->log_id,
							'log_total_stock'         => $log_total_stock,
							'log_total_stock_value'   => $log_total_stock_value,
							'log_average_large_unit'  => $log_average_large_unit,
							'log_average_medium_unit' => $log_average_medium_unit,
							'log_average_small_unit'  => $log_average_small_unit
						);

						$after_row_where_update = array(
							'log_id' => $row_list_detail->log_id,
						);

						$after_row_log_update = $this->Logs_model->update_item($after_row_where_update, $after_row_data_update);
					}
				}else{
					$where_log_delete = array(
						'log_item_id' => $row_list->log_item_id, 
						'log_id' => $row_list->log_id
					);

					$delete_logs = $this->Logs_model->delete($where_log_delete);
				}
			}

			$delete_header = $this->Sales_orders_model->delete_header($row);

			if($delete_header){
				$delete_type = $this->Sales_orders_model->delete_detail($row);
			}
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function print_out($id)
	{	
		$where_header = array('sales_order_header_id' => $id);
		$where_detail = array('sales_order_detail_header_id' => $id);

		$header = $this->Sales_orders_model->salesorder_header($where_header)->row_array();
		$detail = $this->Sales_orders_model->salesorder_detail($where_detail)->result();

		$data['content_title'] = 'Print Penjualan';
		$data['header'] = $header;
		$data['detail'] = $detail;

		$this->twiggy_display('adm/sales_orders/print_out', $data);
	}

	public function ex_average($id='')
	{	
		// $where_header = array('sales_order_header_id' => $id);
		// $where_detail = array('sales_order_detail_header_id' => $id);

		$detail = $this->Logs_model->get_data()->result();

		$data['content_title'] = 'Hasil Perhitungan Average';
		// $data['header'] = $header;
		$data['detail'] = $detail;

		$this->twiggy_display('adm/sales_orders/print_avg', $data);
	}

	public function ed_average($id='')
	{	
		$detail = $this->Logs_model->get_data()->result();
		foreach($detail as $key => $get_row) {
			$data[] = array(
				'log_total_transaction_in_small_unit' => $get_row[$key]->log_total_transaction_in_small_unit,
				'log_total_transaction_value'         => $get_row->log_total_transaction_value,
				'log_total_stock'                     => $get_row->log_total_stock,
				'log_total_stock_value'               => $get_row->log_total_stock_value,
				'log_average_large_unit'              => $get_row->log_average_large_unit,
				'log_average_medium_unit'             => $get_row->log_average_medium_unit,
				'log_average_small_unit'              => $get_row->log_average_small_unit
			);
		}

		echo json_encode($data);
	}

}

?>
